

%% datalog post-processing


clear datalog;

datalog = [];

% get audit vars
datalog_vars = who('datalog__*');

% Move individual variables into audit structure
for i = 1:length(datalog_vars)
    
    if eval([ '~isempty(',  datalog_vars{i}, ');'])
        % eval new var into struct replace double underscores with dots
        eval([strrep(datalog_vars{i}, '__', '.') ' = ' datalog_vars{i} ';']);
    end
end


if isempty( datalog)
    clear datalog;
elseif strcmpi(REVS.model_architecture, 'REVS_CVM') || strcmpi(REVS.model_architecture, 'REVS_HVM')
    
    % Add time
    datalog.time = time;
    
    % Base fuel to volume and CO2 equivalent
    if isfield(datalog,'engine')
        datalog.engine.fuel_rate_Lps			= datalog.engine.fuel_rate_gps /( 1000 * engine.fuel.density_kgpL_15C );
        datalog.engine.fuel_rate_galps			= datalog.engine.fuel_rate_Lps * convert.lit2gal;
        datalog.engine.fuel_gCO2ps				= datalog.engine.fuel_rate_gps * engine.fuel.carbon_weight_fraction * (44.0095/12.0107);
        
        datalog.engine.fuel_consumed_L			= datalog.engine.fuel_consumed_g / ( 1000 * engine.fuel.density_kgpL_15C );
        datalog.engine.fuel_consumed_gallons	= datalog.engine.fuel_consumed_L * convert.lit2gal;
        datalog.engine.fuel_gCO2				= datalog.engine.fuel_consumed_g * engine.fuel.carbon_weight_fraction * (44.0095/12.0107);
        
        
        % Convert to "vehicle" fuel if provided otherwise copy engine
        if isfield(vehicle,'fuel') && ~isempty( vehicle.fuel)
            datalog.vehicle.fuel_consumed_g			= datalog.engine.fuel_consumed_g * engine.fuel.energy_density_MJpkg / vehicle.fuel.energy_density_MJpkg;
            datalog.vehicle.fuel_rate_gps			= datalog.engine.fuel_rate_gps * engine.fuel.energy_density_MJpkg / vehicle.fuel.energy_density_MJpkg;
            
            datalog.vehicle.fuel_rate_Lps			= datalog.vehicle.fuel_rate_gps /(  1000 * vehicle.fuel.density_kgpL_15C);
            datalog.vehicle.fuel_rate_galps			= datalog.vehicle.fuel_rate_Lps * convert.lit2gal;
            datalog.vehicle.fuel_gCO2ps				= datalog.vehicle.fuel_rate_gps * vehicle.fuel.carbon_weight_fraction * (44.0095/12.0107);
            
            datalog.vehicle.fuel_consumed_L			= datalog.vehicle.fuel_consumed_g /( 1000 / vehicle.fuel.density_kgpL_15C);
            datalog.vehicle.fuel_consumed_gallons	= datalog.vehicle.fuel_consumed_L * convert.lit2gal;
            datalog.vehicle.fuel_gCO2				= datalog.vehicle.fuel_consumed_g * vehicle.fuel.carbon_weight_fraction * (44.0095/12.0107);
        else
            datalog.vehicle.fuel_consumed_g			= datalog.engine.fuel_consumed_g;
            datalog.vehicle.fuel_rate_gps			= datalog.engine.fuel_rate_gps;
            
            datalog.vehicle.fuel_rate_Lps			= datalog.engine.fuel_rate_Lps;
            datalog.vehicle.fuel_rate_galps			= datalog.engine.fuel_rate_galps;
            datalog.vehicle.fuel_gCO2ps				= datalog.engine.fuel_gCO2ps;
            
            datalog.vehicle.fuel_consumed_L			= datalog.engine.fuel_consumed_L;
            datalog.vehicle.fuel_consumed_gallons	= datalog.engine.fuel_consumed_gallons;
            datalog.vehicle.fuel_gCO2				= datalog.engine.fuel_gCO2;
        end
    end
end


% cleanup
clear datalog__*;
clear datalog_vars;
clear i;
